globals
[
  initial-discoveries   ;; how many discoveries (white patches) we started with
  innovation-size    ;; how many discoveries are part of the innovation so far
]

breed [frontier frontier-site]    ;; bright blue turtles -- the leading edge of the innovation as it grows

breed [insiders insider]  ;; turtles gradually fading from blue to near black

to setup
  clear-all
  set-default-shape turtles "square"
  ;; make some white discoveries
  ask patches with [(random-float 100) < discovery-density]
    [ set pcolor white ]
  ;; make the row of discoveries connected to the base part of the innovation (from white to blue)
  ask patches with [pycor = min-pycor]
    [ sprout-frontier 1 [set color blue]
      set pcolor blue
    ]
  ;; set known discovery counts
  set initial-discoveries count patches with [pcolor = white]
  set innovation-size count patches with [pcolor = blue ] - 100
  reset-ticks
end

to go
  if not any? turtles  ;; either frontier or insiders
    [ stop ]
  ask frontier
    [ ifelse (random-float 100) < highly-connected
    [ ask neighbors with [pcolor = white]
        [ invent ]
      set breed insiders ]
    [ ask neighbors4 with [pcolor = white]
        [ invent ]
      set breed insiders ]
  ]
  fade-insiders
  tick
end

;; creates the first innovation turtles
to invent  ;; patch procedure
  sprout-frontier 1
    [ set color blue ]
  set pcolor blue
  set innovation-size innovation-size + 1
end

;; achieve fading color effect for the innovation as it advances
to fade-insiders
  ask insiders
    [ set color color - 0.3  ;; make red darker
      if color < blue - 1.5     ;; are we almost at black?
        [ set pcolor color
          die ] ]
end
@#$#@#$#@
GRAPHICS-WINDOW
200
52
612
465
-1
-1
4.0
1
10
1
1
1
0
0
0
1
0
100
0
100
1
1
1
ticks
30.0

MONITOR
8
165
195
210
innovation as % of discoveries
(innovation-size / initial-discoveries)\n* 100
1
1
11

SLIDER
8
52
193
85
discovery-density
discovery-density
0.0
99.0
59.0
1.0
1
%
HORIZONTAL

BUTTON
109
124
191
160
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
8
124
101
160
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
331
481
617
531
Technology Axis
16
0.0
1

TEXTBOX
626
231
776
256
Performance Axis
16
0.0
1

TEXTBOX
230
10
642
84
The Diffusion of Innovation
30
0.0
1

TEXTBOX
12
222
192
418
Grid cells represent discovery sites. Each grid cell is in one of three states:\n\n1) black cells indicate that there is no discovery.\n\n2) white cells indicate that there is a discovery, but it is not part of the innovation.\n\n3) blue cells indicate that there is a discovery, and it has been pulled into the innovation.
11
0.0
1

SLIDER
8
87
193
120
highly-connected
highly-connected
0
100
0.0
5
1
%
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This model simulates the emergence of innovation in a discovery space. Innovation is conceptualized as a "concatenation" of individual discoveries, where discoveries sites (which may be known or unknown) are distributed around a 2D discovery space. It shows that innovation depends critically on the density of individual discoveries, as well as their connectivity. This is an example of a common feature of complex systems: the presence of a non-linear threshold or critical parameter (i.e.: a tipping point). The model is conceptually equivalent to percolation (ex: like rainwater percolating through the ground). 

A discovery site can be in one of three states: when it is black, it represents a potential (but unkonwn) discovery; when it is white, it represents a known discovery; and when it blue, it represents a (white) discovery that has become part of the innovation. One can think of the change from black to white sites as a process of R&D, where investments are (or are not) made to discover something. One can think of the change from white to blue sites as a process of inventiveness, where investments are (or are not) made to learn about and incorporate new discoveries into an existing innovation. 

## HOW IT WORKS

Innovation starts on the bottom edge of the discovery space, and grows to include neighboring discoveries if they exist and are "seen" by the innovation. The base (the x-axis) represents proximate and non-proximate specialization domains (like the locations within the Dewey Decimal system, or the patent classification system). The vertical dimension represents increases in performance within a given location on the x-axis (like the improvement of bike propulsion from push-based (in the 1800s), to pedal-based (in the late 1800s), to gears (in the 1900s), to batteries (in the early 2000s). An innovation spreads in either four directions (to the adjacent discovery sites of the so-called "von Neumann neighborhood") or in eight directions (to all surrounding sites within the so-called "Moore neighborhood"). These two forms of connectivity represent low and high collaborative spirits, respectively.  

The model assumes that discoveries and connectivity are given exogenously at setup. That is, there is no model of the process of research and development (i.e.: of turning black sites to white). Also, there is no model of collaboration (i.e.: of turning von Newmann neighborhoods into Moore neighborhoods). Large clusters of discoveries which are not connected to the innovation arising from the base may exist, but are not known (or "seen") by the innovation. 

## HOW TO USE IT

Select values for the DENSITY of discoveries, and for the percentage of sites that are HIGHLY-CONNECTED. Then, click the SETUP button to set up the discovery sites (white) and the initial innovation (blue along the base).

Click the GO button to start the simulation.

The DISCOVERY-DENSITY slider controls the density of discoveries in the space. The HIGH-CONNECTIVITY slider controls the probability that a given discovery site will be connected to all eight surrounding site, rather than only four adjacent sites. 

## THINGS TO NOTICE

When you run the model, how large does an innovation grow? If you run it again with the same settings, is the innovation the same?? How similar is the innovatoin from run to run?

Each turtle that represents a discovery is created and then incorporated into the innovation without ever moving. If the innovation is made of turtles but no turtles are moving, what does it mean to say that the innovation moves (i.e.: spreads)? This is an example of different levels in a system: at the level of the individual turtles, there is no motion, but at the level of the turtles collectively over time, the innovation grows.

## THINGS TO TRY

Set the density of discoveries to 55% and high-connectivity to 0%. At this setting, there is virtually no chance that the innovation will grow large. Set the density of trees to 70%, and keep the level of high-connectivity at 0%. At this setting, it is almost certain that the innovation will grow very large. When high-connectivity is held constant at 0%, there is a sharp transition of innovation around 59% density. This reveals the existence of a tipping point in the system, which is known as Kalmagorov's Zero-One Law: in a hypothetical infinite square lattice constructed with von Neumann neighborhoods, densities below 59.3% will never percolate (p=0), and densities above 59.3% will always percolate (p=1). 

Try setting density to a value below (but near) the critical value; for example, set it to 45%. Then, vary the level of high-connectivity from 0% to 100% in increments of 25%. Increasing the level of high-connectivity also reveals a tip. That is, the innovation will tip at relatively lower values of density at higher levels of high-connectivity. 

The model includes a BehaviorSpace experiment (see Tools menu) that varies DISCOVERY-DENSITY  and HIGH-CONNECTIVITY from 0 to 100 in increments of 5. Try running these experiments and collecting the data as a "table." Then, plot these data using a box-and-whisker plot in your preferred statistical program. What kind of curve do you get?

## EXTENDING THE MODEL

Varying the neighborhood between von Neumann and Moore connectivity is only one way to change the level of connectivity between discovery sites. For example, an even more adventurous collaborator might look farther out in the discovery space for sub-innovations. Can you develop an alternative way to vary connectivity?

In this model, density and connectivity are set at "setup" and held constant (i.e.: they are set exogenously). Can you alter the processes of discovery and connectivity to allow for strategies of endogenous R&D? And for endogenous collaboration? 

## RELATED MODELS

* Fire
* Percolation
* Rumor Mill

## CREDITS AND REFERENCES

https://en.wikipedia.org/wiki/Forest-fire_model
https://doi.org/10.1016/j.jedc.2003.05.005

## HOW TO CITE

[add citation to EPS when published]
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.3.0
@#$#@#$#@
set density 60.0
setup
repeat 180 [ go ]
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>(innovation-size / initial-discoveries) * 100</metric>
    <steppedValueSet variable="discovery-density" first="0" step="5" last="100"/>
    <steppedValueSet variable="highly-connected" first="0" step="50" last="100"/>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
